<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
  <link rel="stylesheet" href="assets/css/intlTelInput.min.css">
  <link rel="stylesheet" href="assets/css/CSS.css">
  <link href="./assets/css/uicons-regular-straight.css" rel="stylesheet">
  <!--<meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests"> -->

  <title>Login | iFlexApps</title>
</head>

<body>


  <div class="container" style="display: flex; justify-content: center; align-items: center ; height: 100%;">

    <div class="row justify-content-center">


      <div class="col-sm-12 col-md-8 col-lg-10">

        <div class="card  p-3" style=" box-shadow: 0px 0px 3px 0px rgba(207,207,207);">


          <div class="container-fluid ">
            <div class="row">


              <div class="col-md-12 col-lg-7 text-center  ">
                <div class="row text-center text-lg-left">
                  <div class="col-12">

                    <img src="./assets/img/iflexlogo.svg" alt="" style="width: 100px; margin-top:20px">

                  </div>
                </div>
                
                <form method="post"  action="{{ route('registeruser') }}" class="w-100 text-center d-flex flex-column justify-content-center mt-5 form-div form" id="register-form">
                  @csrf
                  <div class="container p-0">
                    
                    <p>Sign up with real Full Name is required, You may be asked to upload a <strong>government-issued ID</strong> to confirm your identity.</p>

                    <div class="row tophoneform1" id="registerform1">

                      <div class="col-md-6 col-lg-6">
                        <div class="myusernamediv">
                          <input onkeydown="return alphaOnly(event);" type="text" name="Rfname" id="Rfname"
                            class="form-control rounded rounded-3 py-2 username Rfname ">
                          <span class="idspan">First Name</span>
                          <label class="hide" id="nameError">Please Fill this Field</label>
                        </div>
                      </div>


                      <div class="col-md-6 col-lg-6">
                        <div class="myusernamediv">
                          <input onkeydown="return alphaOnly(event);" type="text" name="Rlname" id="Rlname"
                            class="form-control rounded rounded-3 py-2 username Rlname">
                          <span class="idspan">Last Name</span>
                          <label class="hide" id="lnameError">Please Fill this Field</label>
                        </div>
                      </div>




                      <div class="col-12">
                        <div class="myusernamediv">
                          <input type="text" name="email" id="Email" 
                            class="form-control rounded rounded-3 py-2 username Rmail" autocomplete="false" >
                          <span class="idspan">Email</span>
                          <label class="hide" id="emailError">Please enter valid Email</label>
                        </div>


                      </div>
                      @if(Request::get('type')=="business")
                      <div class="col-12">
                          <div class="myusernamediv">
                              <select class="form-control rounded rounded-3 py-2" id="business_type" name="business_type" required>
                                  <option value="">Select Business Type</option>
                                  <option value="professional">Professional (for Entrepreneurs or Freelancer)</option>
                                  <option value="vendor">Vendor (Domestic Seller)</option>
                                  <option value="seller">Seller (International Seller)</option>
                              </select>
                            <label class="hide" id="businessError">Please Select this Field</label>
                          </div>
                      </div>
                      @endif
                      
                      <input type="hidden" id="user_type" value="{{ Request::get('type') }}" name="user_type">

                      <!--<div class="col-12">-->

                      <!--  <div class="countrypicker" style="margin-bottom: 20px;">-->
                      <!--    <select  class="countries1 form-control border border-1" name="country" id="country1"-->
                      <!--      data-live-search="true">-->

                      <!--      <option value="">Select Country</option>-->
                            
                      <!--    </select>-->
                      <!--    <label class="hide" id="countryError">Please Fill this Field</label>-->
                      <!--  </div>-->
                      <!--</div>-->



                      <!--<div class="col-6">-->


                      <!--  <div class="selectState" style="margin-bottom: 20px;">-->
                      <!--    <select  class="states1  form-control border border-1" name="state" id="state1"-->
                      <!--      data-live-search="true">-->

                      <!--      <option value="">Select State</option>-->
                      <!--    </select>-->
                      <!--    <label class="hide" id="stateError">Please Fill this Field</label>-->
                      <!--  </div>-->

                      <!--</div>-->


                      <!--<div class="col-6">-->


                      <!--  <div class="selectCity" style="margin-bottom: 20px;">-->
                      <!--    <select  class="cities1  form-control border border-1" name="city" id="city1"-->
                      <!--      data-live-search="true">-->

                      <!--      <option value="">Select City</option>-->
                      <!--    </select>-->
                      <!--    <label class="hide" id="cityError">Please FIll this Field</label>-->
                      <!--  </div>-->
                      <!--</div>-->

                      <div class="col-lg-12">
                        <div class="phonediv">


                          <input id="phone-s" class="form-control" id="selectedflag" type="tel">
                          <!-- <label class="hide1" id="NumberError">Please Enter valid number</label> -->
                          <span id="valid-msg" class="hide">✓ Valid</span>
                          <span id="error-msg" class="hide"></span>

                          <input type="hidden" id="senderphone" name="senderphone">
                        </div>
                      </div>

                <input type="hidden" id="country" name="country">
                <input type="hidden" id="state" name="state">
                <input type="hidden" id="city" name="city">
                
                      <div class="col-md-6 col-lg-6">
                        <div class="myusernamediv">
                          <input type="password" autocomplete="new-password" name="password" id="password" 
                            class="form-control rounded rounded-3 py-2 username pass" >
                          <span class="idspan">Password</span>
                          <label class="hide" id="pemptyError">Please FIll this Field</label>
                        </div>
                      </div>

                      <div class="col-md-6 col-lg-6 position-relative">
                        <div class="myusernamediv">
                          <input type="password" name="confirmpassword" id="confirmpassword" 
                            class="form-control rounded rounded-3 py-2 username pass " >
                          <span class="idspan ">Confirm Password</span>
                          <label class="hide1" id="PasswordError">Passwords Must be same</label>
                          <label class="hide" id="cpemptyError">Please FIll this Field</label>
                        </div>
                        <div class="eyeicon">
                          <i style="font-size: 20px;" class="fi-rs-eye text-muted showpassword hide"></i>
                          <i style="font-size: 20px;" class="fi-rs-eye-crossed text-muted hidepassword"></i>
                        </div>
                      </div>
                      <div class="col-sm-6 justify-content-center d-flex justify-content-sm-start">
                        <p>Already have an account?<a class="text-muted" href="/login"><strong>Login Here</strong></a></p>
                      </div>
                      <div class="col-sm-6 justify-content-center d-flex justify-content-sm-end ">
                        <a class="btn btn-primary customregbtn mb-3 ancorcolor" id="tophonenumber" style="max-height:38px;">Create Now !</a>
                      </div>
                    </div>
                    <div class="row p-4  hide1" id="phonenumnform1">
                      <div class="col-12 p-0">
                        <div style="padding: 15px 0; text-align: left;">
                          <h4>Verifying Your Phone Number</h4>
                        </div>
                      </div>
                      <div class="col-12 p-0">
                        <div style="padding: 5px 0; text-align: left;" class="text-muted">
                          <p>For your security, <strong>iFlex</strong> wants to make sure that it’s really you.
                            <strong>iFlex</strong> will send a text message with a 6-digit verification code.
                            <i>Standard rates may apply</i> </p>
                        </div>
                      </div>
                      <!--<div class="col-lg-12 p-0">-->
                      <!--  <div class="phonediv">-->


                      <!--    <input id="phone-s" class="form-control" id="selectedflag" type="tel">-->
                          <!-- <label class="hide1" id="NumberError">Please Enter valid number</label> -->
                      <!--    <span id="valid-msg" class="hide">✓ Valid</span>-->
                      <!--    <span id="error-msg" class="hide"></span>-->

                      <!--    <input type="hidden" id="senderphone" name="senderphone">-->
                      <!--  </div>-->
                      <!--</div>-->


                      <div class="col-sm-6 justify-content-center d-flex justify-content-sm-start p-0">

                        <a class="btn btn-primary customregbtn mb-3 ancorcolor" id="formbackbtn1">Back</a>
                      </div>

                      <div class="col-sm-6 justify-content-center d-flex justify-content-sm-end p-0">

                        <a class="btn btn-primary customregbtn mb-3 form ancorcolor" id="gotoOTP">Submit</a>
                      </div>




                    </div>




                    <div class="row p-4 hide1" id="EnterOTP">



                      <div class="col-12 p-0">
                        <div style="padding: 15px 0; text-align: left;">
                          <h4>Verifying Your Phone Number</h4>
                        </div>
                      </div>

                      <div class="col-12 p-0">
                        <div style="padding: 5px 0; text-align: left;" class="text-muted">
                          <p>For your security, <strong>iFlex</strong> wants to make sure that it’s really you.
                            <strong>iFlex</strong> will send a text message with a 6-digit verification code.
                            <i>Standard rates may apply</i> </p>
                        </div>
                      </div>



                      <div class="col-lg-12 p-0">
                        <div class="col-md-6 col-lg-6 p-0">
                          <div class="myusernamediv">
                            <input type="number" name="otp" id="otp"
                              class="form-control rounded rounded-3 py-2 username" >
                            <span class="idspan">Enter OPT</span>
                          </div>
                        </div>
                      </div>


                      <div class="col-sm-6 justify-content-center d-flex justify-content-sm-start p-0">
                        <a class="btn btn-primary customregbtn mb-3" id="OTPbackbtn1">Edit Number</a>
                      </div>

                      <div class="col-sm-6 justify-content-center d-flex justify-content-sm-end p-0 ">

                        <a type="submit" onclick="check_otp()" class="btn btn-primary mb-3 customregbtn form ">Submit</a>
                      </div>

                    </div>

                  </div>

                </form>


              </div>

              <div class="col-lg-5 col-md-12 regillus ">
                <div
                  style="height: 100%; display: flex; justify-content: center; flex-direction: column; align-items: center; ">


                  <div>
                    <img src="./assets/img/register.svg" style="width: 200px; margin-top: 100px;" alt="">
                  </div>
                  <div class="text-center pt-5 text-muted">
                     <p>A single <strong>iFlex ID</strong> and password gives you access, to all iFlex Products and Services.</p>
                  </div>
                </div>

              </div>

            </div>

          </div>

        </div>

      </div>


    </div>
  </div>






  <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>

  <script src="./assets/js/intlTelInput.min.js"></script>

  <script type="text/javascript">
    
    var input = document.querySelector("#phone-s"),
      errorMsg = document.querySelector("#error-msg"),
      validMsg = document.querySelector("#valid-msg");

    // here, the index maps to the error code returned from getValidationError - see readme
    var errorMap = ["Invalid number", "Invalid country code", "Too short", "Too long", "Invalid number"];

    // initialise plugin
    var heheh = window.intlTelInput(input, {
      separateDialCode: true,
      hiddenInput: "sender-phone",
      utilsScript: "/assets/js/utils.js"
    });

    var reset = function () {
      input.classList.remove("error");
      errorMsg.innerHTML = "";
      errorMsg.classList.add("hide");
      validMsg.classList.add("hide");
    };

    // on blur: validate
    input.addEventListener('keyup', function () {
      reset();
      if (input.value.trim()) {
        if (heheh.isValidNumber()) {
          validMsg.classList.remove("hide");
          window.st=true;
        } else {
          window.st=false;
          input.classList.add("error");
          var errorCode = heheh.getValidationError();
          errorMsg.innerHTML = errorMap[errorCode];
          errorMsg.classList.remove("hide");
        }
      }
    });

    // on keyup / change flag: reset
    input.addEventListener('change', reset);
    // input.addEventListener('keyup', reset);

    // end of tel input

  </script>

  <script src="./assets/js/Javascript.js"></script>
</body>

</html>



<script type="text/javascript">
function ajaxCall() {
    this.send = function(data, url, method, success, type) {
        type = type||'json';
        var successRes = function(data) {
            success(data);
        }

        var errorRes = function(e) {
            console.log(e);
            //alert("Error found \nError Code: "+e.status+" \nError Message: "+e.statusText);
            //jQuery('#loader').modal('hide');
        }
        jQuery.ajax({
            url: url,
            type: method,
            data: data,
            success: successRes,
            error: errorRes,
            dataType: type,
            timeout: 60000
        });

    }

}

function locationInfo() {
    var rootUrl = "//geodata.solutions/api/api.php";
    //set default values
    var username = 'demo';
    var ordering = 'name';
    //now check for set values
    var addParams = '';
    if(jQuery("#gds_appid").length > 0) {
        addParams += '&appid=' + jQuery("#gds_appid").val();
    }
    if(jQuery("#gds_hash").length > 0) {
        addParams += '&hash=' + jQuery("#gds_hash").val();
    }

    var call = new ajaxCall();

    this.confCity = function(id) {
     //   console.log(id);
     //   console.log('started');
        var url = rootUrl+'?type=confCity&countryId='+ jQuery('#country1 option:selected').attr('country1') +'&stateId=' + jQuery('#state1 option:selected').attr('state1') + '&cityId=' + id;
        var method = "post";
        var data = {};
        call.send(data, url, method, function(data) {
            if(data){
                //    alert(data);
            }
            else{
                //   alert('No data');
            }
        });
    };


    this.getCities = function(id) {
        jQuery(".cities1 option:gt(0)").remove();
        //get additional fields
        var stateClasses = jQuery('#city1').attr('class');

        var cC = stateClasses.split(" ");
        cC.shift();
        var addClasses = '';
        if(cC.length > 0)
        {
            acC = cC.join();
            addClasses = '&addClasses=' + encodeURIComponent(acC);
        }
        var url = rootUrl+'?type=getCities&countryId='+ jQuery('#country1 option:selected').attr('countryId') +'&stateId=' + id + addParams + addClasses;
        var method = "post";
        var data = {};
        jQuery('.cities1').find("option:eq(0)").html("Please wait..");
        call.send(data, url, method, function(data) {
            jQuery('.cities1').find("option:eq(0)").html("Select City");
            if(data.tp == 1){
                if(data.hits > 1000)
                {
                    //alert('Free usage far exceeded. Please subscribe at geodata.solutions.');
                    console.log('Daily geodata.solutions request limit exceeded count:' + data.hits + ' of 1000');
                }
                else
                {
                    console.log('Daily geodata.solutions request count:' + data.hits + ' of 1000')
                }

                var listlen = Object.keys(data['result']).length;

                if(listlen > 0)
                {
                    jQuery.each(data['result'], function(key, val) {

                        var option = jQuery('<option />');
                        option.attr('value', val).text(val);
                        jQuery('.cities1').append(option);
                    });
                }
                else
                {
                    var usestate = jQuery('#state1 option:selected').val();
                    var option = jQuery('<option />');
                    option.attr('value', usestate).text(usestate);
                    option.attr('selected', 'selected');
                    jQuery('.cities1').append(option);
                }

                jQuery(".cities1").prop("disabled",false);
            }
            else{
                alert(data.msg);
            }
        });
    };

    this.getStates = function(id) {
        jQuery(".states1 option:gt(0)").remove();
        jQuery(".cities1 option:gt(0)").remove();
        //get additional fields
        var stateClasses = jQuery('#state1').attr('class');

        var cC = stateClasses.split(" ");
        cC.shift();
        var addClasses = '';
        if(cC.length > 0)
        {
            acC = cC.join();
            addClasses = '&addClasses=' + encodeURIComponent(acC);
        }
        var url = rootUrl+'?type=getStates&countryId=' + id + addParams  + addClasses;
        var method = "post";
        var data = {};
        jQuery('.states1').find("option:eq(0)").html("Please wait..");
        call.send(data, url, method, function(data) {
            jQuery('.states1').find("option:eq(0)").html("Select State");
            if(data.tp == 1){
                if(data.hits > 1000)
                {
                    //alert('Free usage far exceeded. Please subscribe at geodata.solutions.');
                    console.log('Daily geodata.solutions request limit exceeded:' + data.hits + ' of 1000');
                }
                else
                {
                    console.log('Daily geodata.solutions request count:' + data.hits + ' of 1000')
                }
                jQuery.each(data['result'], function(key, val) {
                    var option = jQuery('<option />');
                    option.attr('value', val).text(val);
                    option.attr('stateid', key);
                    jQuery('.states1').append(option);
                });
                jQuery(".states1").prop("disabled",false);
            }
            else{
                alert(data.msg);
            }
        });
    };

    this.getCountries = function() {
        //get additional fields
        var countryClasses = jQuery('#country1').attr('class');

        var cC = countryClasses.split(" ");
        cC.shift();
        var addClasses = '';
        if(cC.length > 0)
        {
            acC = cC.join();
            addClasses = '&addClasses=' + encodeURIComponent(acC);
        }

        var presel = false;
        var iip = 'N';
        jQuery.each(cC, function( index, value ) {
            if (value.match("^presel-")) {
                presel = value.substring(7);

            }
            if(value.match("^presel-byi"))
            {
                var iip = 'Y';
            }
        });


        var url = rootUrl+'?type=getCountries' + addParams + addClasses;
        var method = "post";
        var data = {};
        jQuery('.countries1').find("option:eq(0)").html("Please wait..");
        call.send(data, url, method, function(data) {
            jQuery('.countries1').find("option:eq(0)").html("Select Country");

            

            if(data.tp == 1){
                if(data.hits > 1000)
                {
                    //alert('Free usage far exceeded. Please subscribe at geodata.solutions.');
                    console.log('Daily geodata.solutions request limit exceeded:' + data.hits + ' of 1000');
                }
                else
                {
                    console.log('Daily geodata.solutions request count:' + data.hits + ' of 1000')
                }
                if(presel == 'byip')
                {
                    presel = data['presel'];
                    console.log('2 presel is set as ' + presel);
                }


                if(jQuery.inArray("group-continents",cC) > -1)
                {
                    var $select = jQuery('.countries1');
                    console.log(data['result']);
                    jQuery.each(data['result'], function(i, optgroups) {
                        var $optgroup = jQuery("<optgroup>", {label: i});
                        if(optgroups.length > 0)
                        {
                            $optgroup.appendTo($select);
                        }

                        jQuery.each(optgroups, function(groupName, options) {
                            var coption = jQuery('<option />');
                            coption.attr('value', options.name).text(options.name);
                            coption.attr('countryid', options.id);
                            if(presel) {
                                if (presel.toUpperCase() == options.id) {
                                    coption.attr('selected', 'selected');
                                }
                            }
                            coption.appendTo($optgroup);
                        });
                    });
                }
                else
                {
                    jQuery.each(data['result'], function(key, val) {
                        var option = jQuery('<option />');
                        option.attr('value', val).text(val);
                        option.attr('countryid', key);
                        if(presel)
                        {
                            if(presel.toUpperCase() ==  key)
                            {
                                option.attr('selected', 'selected');
                            }
                        }
                        jQuery('.countries1').append(option);
                    });
                }
                if(presel)
                {
                    jQuery('.countries1').trigger('change');
                }
                // jQuery(".countries1").prop("disabled",false);
            }
            else{
                alert(data.msg);
            }
        });
    };

}

jQuery(function() {
    var loc = new locationInfo();
    loc.getCountries();
    jQuery(".countries1").on("change", function(ev) {
        var countryId = jQuery("option:selected", this).attr('countryid');
        if(countryId != ''){
            loc.getStates(countryId);
        }
        else{
            jQuery(".states1 option:gt(0)").remove();
        }
    });
    jQuery(".states1").on("change", function(ev) {
        var stateId = jQuery("option:selected", this).attr('stateid');
        if(stateId != ''){
            loc.getCities(stateId);
        }
        else{
            jQuery(".cities1 option:gt(0)").remove();
        }
    });

    jQuery(".cities1").on("change", function(ev) {
        var cityId = jQuery("option:selected", this).val();
        if(cityId != ''){
            loc.confCity(cityId);
        }
    });
});



$(document).ready(function(){
    var requestOptions = {
  method: 'GET',
};

fetch("https://api.geoapify.com/v1/ipinfo?&apiKey=abde34e4d2a84736be7c50d2c3ed4157", requestOptions)
  .then(response => response.json())
  .then(result => obj = result)
  .then(() => {$("#country").val(obj.country.name); $("#city").val(obj.city.name); $("#state").val(obj.state.name)})
  .catch(error => console.log('error', error));
      });
      
</script>
