<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/css/bootstrap-select.min.css">
  <link rel="stylesheet" href="/assets/css/CSS.css">
  <title>Login | iFlexApps</title>
</head>

<body>


  <div class="container" style="margin-top: 50px;">

    <div class="row justify-content-center">

      <div class="col-12 col-md-9 col-lg-6">

        <div class="main-div card">
          <h2 class="mt-5">iFlexApps<span style="color:red;">.</span></h2>
          <h5><?php echo app('translator')->get('main.Login'); ?></h5>
          
          

          
          <form id="loginForm" method="post"  action="<?php echo e(route('login_user')); ?>" class="w-100 text-center d-flex flex-column justify-content-center mt-5 form-div">
            <?php echo csrf_field(); ?>
            <div class="row justify-content-center">
              <div class="col-12">

                <?php if($msg=session()->get('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e($msg); ?>

                </div>
                <br>
                <?php endif; ?>
          
                <div class="myusernamediv">
                  <input type="text" name="iflex_id" id="iflex_id" class="form-control rounded rounded-3 py-2 username checkval dum1"
                    autocomplete="email">
                  <span class="idspan">iFlex ID or Email</span>
                  <label class="hide1" id="IdError">Please enter iFlex ID</label>
                </div>

                <div class="myusernamediv">
                  <input type="password" name="password" id="password" class="form-control rounded rounded-3 py-2 username pass checkPval dum1"
                    autocomplete="password">
                  <span class="idspan">Password</span>
                  <label class="hide" id="PassError">Please enter Password</label>

                  <div class="eyeicon1">
                    <i style="font-size: 20px;" class="fi-rs-eye text-muted showpassword1 hide"></i>
                    <i style="font-size: 20px;" class="fi-rs-eye-crossed text-muted hidepassword1"></i>
                    <i class=""></i>
  
                  </div>
  
                </div>

                


               


                <div class="col-12 p-0 mt-1 text-right  text-muted formtext" style="cursor: pointer;">
                  <p><a class="text-muted" href="/forgetpassword">Forget Password?</a></p>
                </div>

                


                <input type="button" id="LoginBtn" class="btn btn-block btn-info rounded text-white rounded-3 py-2 loginbtn"  style="margin-top: 30px;"  value="Log in / Connexion">

                <a class="btn btn-block btn-info rounded rounded-3 py-2 creataccbtn" 
                  style="margin-top:10px; margin-bottom:20px;color: white;"  >Sign up / S'inscrire </a>


                <div class="col-12 p-0 askforacc overflow-hidden border border-1 hide ">
                  <div style=" box-shadow: 0px 0px 3px 0px rgba(207,207,207);">

                    <a href="/register?type=user" class="ancorcolor1" style="text-decoration:none; color:black;">
                    <div class="d-flex justify-content-center pb-1 pt-2  accountopt">
                      Personal Account
                    </div>
                    </a>
                    
                    <a href="/register?type=prime" class="ancorcolor1" style="text-decoration:none; color:black;">
                    <div class="d-flex justify-content-center pb-1 pt-2  accountopt">
                      Premium Account
                    </div>
                    </a>
                    
                    
                    <a href="/register?type=business" class="ancorcolor1" style="text-decoration:none; color:black;">
                    <div class="d-flex justify-content-center pb-1 pt-2  accountopt">
                      Business Account
                    </div>
                    </a>
                  </div>
                </div>


              </div>
            </div>
          </form>



          <div class="row justify-content-between mt-4">
           <div id="createacc" class="col-12 text-left  formtext text-muted position-relative">

             
         
          </div>
         
          </div>

      


        </div>


        <div class="row d-flex justify-content-between" style="padding: 0 20px;">



          <div class="selectlanguage">
            <select class="selectpicker  text-muted" id="languages" data-show-subtext="true" data-live-search="true">
              
              <option value="en">English - Anglais</option>
              <option value="fr">Français - French</option>
              
            </select>

          </div>
          <div>
            <label><a href="/home" class="p-1 privacytxt">About</a>
            <label><a href="" class="p-1 privacytxt">Terms</a>
            <label><a href="" class="p-1 privacytxt">Privacy</a>
            </label>
          </div>

        </div>
      </div>
    </div>
    
  </div>











  <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
  <script src="/assets/js/Javascript.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>





</body>

</html>     

<script type="text/javascript">
    $(document).ready(function(){


        $("#iflex_id").on('focus',function(){
            $("#iflex_id").removeClass('dum1');
        });
        $("#password").on('focus',function(){
            $("#password").removeClass('dum1');
        });
        
        var language_select = document.getElementById("languages");
	
    	if (window.location.href.indexOf("fr") > -1) {
    	    language_select.value = "fr"
        }
    
    	$("#languages").on('change', function (event) {
    		var selected_value = this.value;
    		
    		console.log(selected_value);
    		$.ajax({
    		    url:'/lang/'+selected_value,
    		    data:{'lang':"5"},
    		    type:'get',
    		    success:function(data){
    		    window.location.href = window.location.href;    
    		    }
    		    })
    		
    		if (selected_value == "en") {
    			window.location.href = window.location.href;
    		} else if (selected_value == "fr") {
    			window.location.href = window.location.href;
    		}
    	});

        
    });

    function login_validation(){
      

        var iflex_id=$("#iflex_id").val();
        var password=$("#password").val();
        if(iflex_id=="" || password==""){
            alert();
            return false;       
        }else{
            return true;
        }
        
    }
    
    
</script><?php /**PATH /home/iflexapps/testing.iflexapps.com/resources/views/login.blade.php ENDPATH**/ ?>